<?php
/*
 * @version		$Id: komento_plugin.php 3.3.0 2019-01-25 $
 * @package		All Video Share
 * @copyright   Copyright (C) 2012-2019 MrVinoth
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once JPATH_ROOT . '/components/com_komento/komento_plugins/abstract.php';

class KomentoComAllVideoShare extends KomentoExtension {

	public $_item;

    public $_map = array(
        'id'         => 'id',
        'title'      => 'title',
        'hits'       => 'views',
        'created_by' => 'user',
        'catid'      => 'catid',
        'permalink'  => 'permalink_field'
 	);

	public function __construct( $component ) {
		parent::__construct( $component );
    }	
		
    public function load( $cid ) {
	
        static $instances = array();
		
       	if ( ! isset( $instances[ $cid ] ) ) {
			$app = JFactory::getApplication();	
	  		$db = JFactory::getDBO();
			
	  		$query = "SELECT * FROM #__allvideoshare_videos WHERE published=1 AND id=" . (int) $cid; 
      		$db->setQuery( $query );
      		$this->_item = $db->loadObject();	 

	  		$itemId = $app->input->getInt('Itemid') ? '&Itemid=' . $app->input->getInt( 'Itemid' ) : '';
	  
	  		$this->_item->permalink_field = JRoute::_( "index.php?option=com_allvideoshare&view=video&slg=" . $this->_item->slug . $itemId );	  
	   		$instances[ $cid ] = $this->_item;	   
   		} 
		
      	$this->_item = $instances[ $cid ];
		
      	return $this;
        
    }
	
	public function getContentId() {
		return $this->_item->{$this->_map['id']};
	}
	
	public function getContentHits() {
		return $this->_item->{$this->_map['hits']};
	}
	
	public function getAuthorId() {
		return $this->_item->{$this->_map['created_by']};
	}
	
    public function getContentIds( $categories = '' ) {
	   return;		
   	}

    public function getCategories() {
        return;
    }

    // to determine if is listing view
    public function isListingView() {
	
		$app = JFactory::getApplication();	
		
		$views = array( 'videos', 'categories' );		
		return in_array( $app->input->get( 'view' ), $views );

    }

    // to determine if is entry view
    public function isEntryView() {
	
		$app = JFactory::getApplication();	
		return 'video' == $app->input->get( 'view' );
		 
    }

    public function onExecute( &$article, $html, $view, $options = array() ) {
	
        // $html is the html content generated by Komento
		$config = Komento::getConfig( 'com_allvideoshare' );
		$model = Komento::getModel( 'comments' );
     	$count = $model->getCount( $this->component, $this->getContentId() );
      	$article->numOfComments = $count;

        return $html;
		
    }
	
	// Load backend Details	
	public function getComponentIcon() {
  		 return './components/com_allvideoshare/assets/logo.png';
	}
 
	public function getComponentName() {
  		 return 'All Video Share';
	}	
			
}